<?php

namespace Bongo\Estimate\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SearchRequest extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('estimate.recaptcha.enabled');
        $recaptchaMinScore = config('estimate.recaptcha.min_score', 0.5);

        return [
            'line_1' => 'required',
            'postcode' => 'required',

            'g-recaptcha-response' => [
                "recaptchav3:estimate_search,{$recaptchaMinScore},",
                Rule::requiredIf(fn () => $recaptchaEnabled),
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'g-recaptcha-response' => [
                'recaptchav3' => 'reCAPTCHA validation failed, please try again or contact us for more assistance',
            ],
        ];
    }
}
