<?php

namespace Bongo\Estimate\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreStep1Request extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('estimate.recaptcha.enabled');
        $recaptchaMinScore = config('estimate.recaptcha.min_score', 0.5);

        return [
            'first_name' => 'required|string|max:50',
            'last_name' => 'required|string|max:50',
            'email' => 'required|string|email:rfc,dns|max:50',
            'phone' => 'required|string|max:20',

            'accepted_terms' => 'required|numeric',
            'marketing_emails' => 'required|numeric',

            'g-recaptcha-response' => [
                "recaptchav3:estimate_step_1,{$recaptchaMinScore},",
                Rule::requiredIf(fn () => $recaptchaEnabled),
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'g-recaptcha-response' => [
                'recaptchav3' => 'reCAPTCHA validation failed, please try again or contact us for more assistance',
            ],
        ];
    }
}
