<?php

namespace Bongo\Estimate\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class StoreStep2Request extends FormRequest
{
    public function rules(): array
    {
        $recaptchaEnabled = setting()->reCaptchaEnabled() && config('estimate.recaptcha.enabled');
        $recaptchaMinScore = config('estimate.recaptcha.min_score', 0.5);

        return [
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
            'areas' => 'required|string',
            'marker_moved' => 'required|numeric',
            'total_area_m2' => 'required|numeric',

            'g-recaptcha-response' => [
                "recaptchav3:estimate_step_2,{$recaptchaMinScore},",
                Rule::requiredIf(fn () => $recaptchaEnabled),
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'g-recaptcha-response' => [
                'recaptchav3' => 'reCAPTCHA validation failed, please try again or contact us for more assistance',
            ],
        ];
    }
}
