<?php

namespace Bongo\Estimate\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class EstimateResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'uuid' => $this->uuid,
            'number' => config('estimate.number_prefix').$this->number,
            'date' => ! empty($this->date) ? $this->date->format('d/m/Y H:i') : null,
            'step' => $this->step,
            'status' => $this->status,

            'line_1' => $this->line_1,
            'line_2' => $this->line_2,
            'line_3' => $this->line_3,
            'city' => $this->city,
            'county' => $this->county,
            'postcode' => $this->postcode,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,

            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'accepted_terms' => $this->accepted_terms,
            'marketing_emails' => $this->marketing_emails,

            'total_area_m2' => ! empty($this->total_area_m2) ? number_format($this->total_area_m2, 2) : 0,
            'cost_per_m2' => ! empty($this->cost_per_m2) ? number_format($this->cost_per_m2, 2) : 0.00,
            'subtotal' => ! empty($this->subtotal) ? number_format($this->subtotal, 2) : 0.00,
            'tax_rate' => ! empty($this->tax_rate) ? number_format($this->tax_rate) : 0,
            'tax' => ! empty($this->tax) ? number_format($this->tax, 2) : 0.00,
            'total' => ! empty($this->total) ? number_format($this->total, 2) : 0.00,

            'created_at' => ! empty($this->created_at) ? $this->created_at->format('d/m/Y H:i') : null,
        ];
    }
}
