<?php

namespace Bongo\Estimate\Mailables;

use Bongo\Estimate\Models\Estimate;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Mail\Mailable;

class EstimateMailable extends Mailable
{
    protected Estimate $estimate;

    public function __construct(Estimate $estimate)
    {
        $this->estimate = $estimate;
    }

    /**
     * @throws BindingResolutionException
     */
    public function build(): EstimateMailable
    {
        return $this
            ->from(
                config("settings.mail_from_address"),
                config("settings.mail_from_name")
            )
            ->replyTo(
                setting("package::estimate.sales_email"),
                setting("client::company.name"),
            )
            ->cc(setting("package::estimate.sales_email"))
            ->subject("Estimate:".config('estimate.number_prefix').$this->estimate->number)
            ->view('estimate::mail.estimate', [
                'estimate' => $this->estimate,
            ])
            ->text('estimate::mail.estimate_plain', [
                'estimate' => $this->estimate,
            ]);
    }
}
