<?php

namespace Bongo\Estimate\Maps;

class StaticMap
{
    const MIN_ZOOM = 1;
    const MAX_ZOOM = 21;
    const URL_MAX_LENGTH = 2046;
    const FORMAT = ['png8', 'png', 'png32', 'jpg', 'gif', 'jpg-baseline'];
    const MAP_TYPE = ['roadmap', 'satellite', 'hybrid', 'terrain'];

    protected string $key;

    protected Point $center;

    protected int $zoom = 20;

    protected string $size = "750x500";

    protected int $scale = 2;

    protected string $mapType = 'satellite';

    protected array $markers = [];

    protected array $paths = [];

    public function getKey(): string
    {
        return $this->key;
    }

    public function setKey(string $key): self
    {
        $this->key = $key;

        return $this;
    }

    public function getCenter(): Point
    {
        return $this->center;
    }

    public function setCenter(array $cords): self
    {
        $this->center = new Point($cords);

        return $this;
    }

    public function getZoom(): int
    {
        return $this->zoom;
    }

    public function setZoom(int $zoom): self
    {
        $this->zoom = $zoom;

        return $this;
    }

    public function getSize(): string
    {
        return $this->size;
    }

    public function setSize(string $size): self
    {
        $this->size = $size;

        return $this;
    }

    public function getScale(): int
    {
        return $this->scale;
    }

    public function setScale(int $scale): self
    {
        $this->scale = $scale;

        return $this;
    }

    public function getMapType(): string
    {
        return $this->mapType;
    }

    public function setMapType(string $mapType): self
    {
        $this->mapType = $mapType;

        return $this;
    }

    public function getMarkers(): array
    {
        return $this->markers;
    }

    public function setMarkers(array $markers): self
    {
        $this->markers = $markers;

        return $this;
    }

    public function addMarker(Marker $marker): self
    {
        $this->markers[] = $marker;

        return $this;
    }

    public function getPaths(): array
    {
        return $this->paths;
    }

    public function setPaths(array $paths): self
    {
        $this->paths = $paths;

        return $this;
    }

    public function addPath(Path $path): self
    {
        $this->paths[] = $path;

        return $this;
    }

    public function generateUrl(): string
    {
        return (new URLGenerator($this))->generate();
    }

    public function generateImage(string $name, string $path): string
    {
        return (new ImageGenerator($this->generateUrl(), $name, $path))->generate();
    }
}
