<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddSentAtColumnToEstimatesTable extends Migration
{
    public function up()
    {
        if (! Schema::hasColumn('estimates', 'sent_at')) {
            Schema::table('estimates', function (Blueprint $table) {
                $table->timestamp('sent_at')
                    ->nullable()
                    ->after('updated_at');
            });
        }
    }

    public function down()
    {
        Schema::table('estimates', function (Blueprint $table) {
            $table->dropColumn('sent_at');
        });
    }
}
