<?php

use Illuminate\Database\Migrations\Migration;

class AddAdditionalStatusToEstimatesTable extends Migration
{
    public function up()
    {
        DB::statement("
            ALTER TABLE `estimates`
            CHANGE COLUMN `status`
            `status` ENUM('draft','pending','accepted','rejected')
            DEFAULT 'draft'
        ");
        DB::statement("
            UPDATE `estimates`
            SET `status` = 'draft'
            WHERE `status` = 'pending'
        ");
    }

    public function down()
    {
        DB::statement("
            UPDATE `estimates`
            SET `status` = 'pending'
            WHERE `status` = 'draft'
        ");
        DB::statement("
            ALTER TABLE `estimates`
            CHANGE COLUMN `status`
            `status` ENUM('pending','accepted','rejected')
            DEFAULT 'pending'
        ");
    }
}
