<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddExportErrorColumnToEstimatesTable extends Migration
{
    public function up(): void
    {
        if (! Schema::hasColumn('estimates', 'export_error')) {
            Schema::table('estimates', function (Blueprint $table) {
                $table->text('export_error')
                    ->nullable()
                    ->after('exported_at');
            });
        }
    }

    public function down(): void
    {
        Schema::table('estimates', function (Blueprint $table) {
            $table->dropColumn('export_error');
        });
    }
}
