<?php

use Bongo\Estimate\Http\Controllers\Backend\EstimateController;
use Bongo\Estimate\Http\Controllers\Backend\EstimateDatatableController;
use Illuminate\Support\Facades\Route;

Route::namespace('Bongo\Estimate\Http\Controllers')
    ->middleware('web')
    ->group(function () {

        Route::namespace('Backend')
            ->middleware(['auth', 'employee'])
            ->prefix(config('settings.backend_prefix'))
            ->as('backend.')
            ->group(function () {

                Route::as('estimate.')
                    ->prefix(config('estimate.backend_prefix'))
                    ->group(function () {

                        Route::get('/', [EstimateController::class, 'index'])
                            ->name('index');

                        Route::get('datatable', [EstimateDatatableController::class, 'index'])
                            ->name('datatable');

                        // Estimate/{estimate}/
                        Route::prefix('{estimate}')
                            ->group(function () {
                                Route::get('/', [EstimateController::class, 'show'])
                                    ->name('show');

                                Route::post('update', [EstimateController::class, 'update'])
                                    ->name('update');
                            });
                    });
            });

    });
