<?php

use Illuminate\Support\Facades\Route;
use Spatie\Honeypot\ProtectAgainstSpam;

/*
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
Route::namespace('Bongo\Estimate\Http\Controllers')
     ->middleware('web')
     ->group(function () {

         // Frontend Routes...
         Route::namespace('Frontend')
              ->as('frontend.')
              ->group(function () {

                  // Estimate
                  Route::prefix(config('estimate.prefix'))
                       ->as('estimate.')
                       ->group(function () {

                           Route::get('/')
                               ->name('index')
                               ->uses('Step1Controller@index');

                           Route::get('/reset')
                               ->name('reset')
                               ->uses('SearchController@reset');

                           Route::post('search')
                               ->name('search')
                               ->uses('SearchController@index')
                               ->middleware(ProtectAgainstSpam::class);

                           Route::prefix('step-1')
                               ->as('step_1.')
                               ->group(function () {
                                   Route::get('/')
                                       ->name('show')
                                       ->uses('Step1Controller@show');

                                   Route::post('store')
                                       ->name('store')
                                       ->uses('Step1Controller@store')
                                       ->middleware(ProtectAgainstSpam::class);
                               });

                           Route::prefix('step-2')
                               ->as('step_2.')
                               ->group(function () {
                                   Route::get('/')
                                       ->name('show')
                                       ->uses('Step2Controller@show');

                                   Route::post('store')
                                       ->name('store')
                                       ->uses('Step2Controller@store')
                                       ->middleware(ProtectAgainstSpam::class);
                               });

                           Route::prefix('step-3')
                               ->as('step_3.')
                               ->group(function () {
                                   Route::get('/')
                                       ->name('show')
                                       ->uses('Step3Controller@show');
                               });
                       });
              });
     });
