<?php

namespace Bongo\Estimate\Traits;

trait HasStatus
{
    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopePending($query)
    {
        return $query->where('status', self::PENDING);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeAccepted($query)
    {
        return $query->where('status', self::ACCEPTED);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeRejected($query)
    {
        return $query->where('status', self::REJECTED);
    }

    /**
     * @return bool
     */
    public function isPending()
    {
        return $this->status === self::PENDING;
    }

    /**
     * @return bool
     */
    public function isAccepted()
    {
        return $this->status === self::ACCEPTED;
    }

    /**
     * @return bool
     */
    public function isRejected()
    {
        return $this->status === self::REJECTED;
    }
}
