@extends('framework::backend.layouts.app')

@section('content')
    <form method="POST" action="{{ route('backend.estimate.update', $estimate) }}">
        {{ csrf_field() }}

        @component('blade::content_header')
            {{ config('estimate.number_prefix').$estimate->number }} - {{ $estimate->name }}
            @slot('actions')
                @backButton(['name' => trans('estimate::backend.index'), 'url' => route('backend.estimate.index')])
                @saveButton(['name' => trans('estimate::backend.update')])
            @endslot
        @endcomponent

        @component('blade::content_body')
            <section class="md:grid md:grid-cols-2 md:gap-6">
                <div class="md:col-span-1">
                    @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">

                            <div class="sm:col-span-1">
                                <div class="form-group">
                                    <label class="text-sm leading-5 font-medium text-gray-500">Reference</label>
                                    <div class="mt-1 text-sm leading-5 text-gray-900">
                                        {{ config('estimate.number_prefix').$estimate->number }}
                                    </div>
                                </div>
                            </div>

                            <div class="sm:col-span-1">
                                @if(! empty($estimate->date))
                                    @static([
                                        'name' => 'Date',
                                        'value' => $estimate->date->format('d/m/Y')
                                    ])
                                @else
                                    @static([
                                        'name' => 'Date',
                                        'value' => ! empty($estimate->created_at) ? $estimate->created_at->format('d/m/Y H:i') : null
                                    ])
                                @endif
                            </div>

                            <div class="sm:col-span-1">
                                @static(['name' => 'Step', 'value' => $estimate->step])
                            </div>

                            <div class="sm:col-span-1">
                                @select([
                                    'name' => 'status',
                                    'value' => $estimate->status,
                                    'options' => get_enum_values('estimates', 'status'),
                                    'required' => 'true'
                                ])
                            </div>

                            @if($estimate->hasExportError())
                                <div class="sm:col-span-2">
                                    @static([
                                        'class' => 'text-red-600 font-bold',
                                        'name' => 'Export Error',
                                        'value' => $estimate->export_error,
                                    ])
                                </div>
                            @elseif($estimate->hasExportedAt())
                                <div class="sm:col-span-1">
                                    @static([
                                        'class' => 'text-green-500 font-bold',
                                        'name' => 'Last Exported',
                                        'value' => $estimate->exported_at->format('d/m/Y H:i'),
                                    ])
                                </div>
                            @endif
                        </div>
                    @endcomponent
                </div>

                <div class="md:col-span-1">
                    @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                            <div class="sm:col-span-1">
                                @static(['name' => 'First Name', 'value' => $estimate->first_name])
                            </div>
                            <div class="sm:col-span-1">
                                @static(['name' => 'Last Name', 'value' => $estimate->last_name])
                            </div>
                            <div class="sm:col-span-2 lg:col-span-1">
                                @static([
                                    'name' => 'Email',
                                    'value' => $estimate->email,
                                    'link' => ! empty($estimate->email) ? "mailto:{$estimate->email}" : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                    'name' => 'Phone',
                                    'value' => $estimate->phone,
                                    'link' => ! empty($estimate->phone) ? "tel:{$estimate->phone}" : null
                                ])
                            </div>
                        </div>
                    @endcomponent
                </div>

                <div class="md:col-span-1">
                    @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                            <div class="sm:col-span-1">
                                @static(['name' => 'Line 1', 'value' => $estimate->line_1])
                            </div>
                            <div class="sm:col-span-1">
                                @static(['name' => 'Line 2', 'value' => $estimate->line_2])
                            </div>
                            <div class="sm:col-span-1">
                                @static(['name' => 'Line 3', 'value' => $estimate->line_3])
                            </div>
                            <div class="sm:col-span-1">
                                @static(['name' => 'City', 'value' => $estimate->city])
                            </div>
                            <div class="sm:col-span-1">
                                @static(['name' => 'County', 'value' => $estimate->county])
                            </div>
                            <div class="sm:col-span-1">
                                @static(['name' => 'Postcode', 'value' => $estimate->postcode])
                            </div>
                        </div>
                    @endcomponent
                </div>

                <div class="md:col-span-1">
                    @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                            @if(count($estimate->getAreas()) > 1)
                                @foreach($estimate->getAreas() as $area)
                                    <div class="sm:col-span-1">
                                        <div class="form-group">
                                            <label class="text-sm leading-5 font-medium text-gray-500">
                                                Area - {{ $area->label }}
                                            </label>
                                            <div class="mt-1 text-sm leading-5 text-gray-900">
                                                {{ $area->no_of_m2 ? number_format($area->no_of_m2, 2) : 0 }} m2
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif

                            <div class="sm:col-span-1">
                                <div class="form-group">
                                    <label class="text-sm leading-5 font-medium text-gray-500">
                                        Total Area
                                    </label>
                                    <div class="mt-1 text-sm leading-5 text-gray-900">
                                        {{ ! empty($estimate->total_area_m2) ? number_format($estimate->total_area_m2, 2) : 0 }} m2
                                    </div>
                                </div>
                            </div>

                            <div class="sm:col-span-1">
                                @static(['name' => 'Cost Per m2', 'value' => $estimate->cost_per_m2])
                            </div>
                        </div>
                    @endcomponent
                </div>

                <div class="md:col-span-1">
                    @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                        <div class="grid grid-cols-1 col-gap-4 row-gap-4 sm:grid-cols-2">
                            <div class="sm:col-span-1">
                                @static([
                                'name' => 'Subtotal',
                                'value' => ! empty($estimate->subtotal) ? '£'.number_format($estimate->subtotal, 2) : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                'name' => 'Tax Rate',
                                'value' => ! empty($estimate->tax_rate) ? $estimate->tax_rate.'%' : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                'name' => 'Tax',
                                'value' => ! empty($estimate->tax) ? '£'.number_format($estimate->tax, 2) : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                'name' => 'Total',
                                'value' => ! empty($estimate->total) ? '£'.number_format($estimate->total, 2) : null
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                'name' => 'Installments',
                                'value' => config('estimate.chargeable_treatments_per_year')
                                ])
                            </div>
                            <div class="sm:col-span-1">
                                @static([
                                'name' => 'Per Month',
                                'value' => ! empty($estimate->per_month) ? '£'.number_format($estimate->per_month, 2) : null
                                ])
                            </div>
                        </div>
                    @endcomponent
                </div>

                <div class="md:col-span-1">
                    @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                        <div class="map">
                            <img class="img-fluid" src="{{ $estimate->getStaticMap() }}" alt="">
                        </div>
                    @endcomponent
                </div>

            </section>
        @endcomponent

    </form>
@stop
