@extends('framework::frontend.layouts.wizard')

@section('content')
    <div class="wizard">

        <div class="wizard-header">
            <div class="logo">
                <a href="{{ url('/') }}">
                    <img alt="{{ setting("client::company.name") }}"
                         src="{{ setting("theme::logo.default") }}"
                    />
                </a>
            </div>
            <div class="contact">
                <div class="contact-email">
                    <span>Send us an email</span>
                    <a href="mailto:{{ setting("client::company.email") }}">
                        {{ trim(setting("client::company.email")) }}
                    </a>
                </div>
                <div class="contact-number">
                    <span class="d-block">Call us now</span>
                    <a href="tel:{{ str_replace(' ', '', setting()->getClientPhoneNumber()) }}">
                        {{ trim(setting()->getClientPhoneNumber()) }}
                    </a>
                </div>
            </div>
        </div>

        <div class="wizard-steps">
            <div class="wizard-step {{ $estimate->stepIs(1) ? 'active' : '' }}{{ $estimate->stepIsGt(1) ? 'complete' : '' }}">
                @if($estimate->stepIs(1))
                    <div class="wizard-step-indicator"></div>
                @endif
                <div class="wizard-step-link">
                    <span class="wizard-step-number">
                        {!! $estimate->stepIsGt(1) ? '<i class="fa fa-check"></i>' : '01' !!}
                    </span>
                    <span class="wizard-step-label">
                        {{ setting('package::estimate.step_1') }}
                    </span>
                </div>
            </div>

            <div class="wizard-step {{ $estimate->stepIs(2) ? 'active' : '' }} {{ $estimate->stepIsGt(2) ? 'complete' : '' }}">
                @if($estimate->stepIs(2))
                    <div class="wizard-step-indicator"></div>
                @endif
                <div class="wizard-step-link">
                    <span class="wizard-step-number">
                        {!! $estimate->stepIsGt(2) ? '<i class="fa fa-check"></i>' : '02' !!}
                    </span>
                    <span class="wizard-step-label">
                        {{ setting('package::estimate.step_2') }}
                    </span>
                </div>
                <div class="wizard-step-separator">
                    <svg viewBox="0 0 12 82" fill="none" preserveAspectRatio="none">
                        <path d="M0.5 0V31L10.5 41L0.5 51V82" stroke="currentcolor" vector-effect="non-scaling-stroke"></path>
                    </svg>
                </div>
            </div>

            <div class="wizard-step {{ $estimate->stepIs(3) ? 'active' : '' }}">
                @if($estimate->stepIs(3))
                    <div class="wizard-step-indicator"></div>
                @endif
                <div class="wizard-step-link">
                    <span class="wizard-step-number">03</span>
                    <span class="wizard-step-label">
                        {{ setting('package::estimate.step_3') }}
                    </span>
                </div>
                <div class="wizard-step-separator">
                    <svg viewBox="0 0 12 82" fill="none" preserveAspectRatio="none">
                        <path d="M0.5 0V31L10.5 41L0.5 51V82" stroke="currentcolor" vector-effect="non-scaling-stroke"></path>
                    </svg>
                </div>
            </div>
        </div>

        @yield('wizard_content')
    </div>
@stop
