@extends('estimate::frontend.layout')

@section('body_class', 'estimate-page')
@section('page_title', 'Step 1 > '.setting('package::estimate.step_1'))
@section('meta_title', 'Step 1 > '.setting('package::estimate.step_1'))
@section('meta_description', 'Step 1 > '.setting('package::estimate.step_1'))

@section('wizard_content')
    @if(empty($estimate->postcode))
        <form action="{{ route('frontend.estimate.search') }}" method="POST">
            <div class="validation">
                {{ csrf_field() }}
                @honeypot
                @if(setting()->reCaptchaEnabled())
                    {!! RecaptchaV3::field('estimate_search') !!}
                @endif
            </div>

            <div class="wizard-content">
                <section class="address-details">
                    <h2>Address Details</h2>
                    <p>Please enter the first line and postcode of your address, to measure your lawn</p>
                    <div class="row">
                        <div class="col-md-8">

                            <div class="input-group">
                                <input
                                    class="form-control w-md-40"
                                    name="line_1"
                                    type="text"
                                    maxlength="50"
                                    value="{{ old('line_1', $estimate->line_1) }}"
                                    placeholder="e.g. 48, common rd"
                                    autocomplete="line-1"
                                    required
                                >
                                <input
                                    class="form-control w-md-30"
                                    name="postcode"
                                    type="text"
                                    maxlength="10"
                                    value="{{ old('postcode', $estimate->postcode) }}"
                                    placeholder="{{ setting('package::estimate.postcode_placeholder') }}"
                                    autocomplete="postal-code"
                                    required
                                >
                                <div class="input-group-append">
                                    <button
                                        class="form-submit btn btn-xl btn-outline btn-primary text-1 font-weight-bold text-uppercase"
                                        type="submit"
                                    >
                                        Search
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </form>
    @else
        <form action="{{ route('frontend.estimate.step_1.store') }}" method="POST">
            <div class="validation">
                {{ csrf_field() }}
                @honeypot
                @if(setting()->reCaptchaEnabled())
                    {!! RecaptchaV3::field('estimate_step_1') !!}
                @endif
            </div>

            <div class="wizard-content">
                <section class="address-details">
                    <h2>Address Details</h2>
                    <p>
                        We found the following location for your postcode, is this correct?
                        <a href="{{ route('frontend.estimate.reset') }}">Reset Address</a>
                    </p>
                    <div class="address-result">
                        {{ $estimate->address }}
                    </div>
                </section>

                <section class="contact-details">
                    <h2>Contact Details</h2>
                    <p>In order to send your quote, please enter your contact details bellow.</p>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <input
                                    class="form-control"
                                    name="first_name"
                                    type="text"
                                    maxlength="50"
                                    value="{{ old('first_name', $estimate->first_name) }}"
                                    placeholder="Your First Name..."
                                    autocomplete="given-name"
                                    required
                                >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <input
                                    class="form-control"
                                    name="last_name"
                                    type="text"
                                    maxlength="50"
                                    value="{{ old('last_name', $estimate->last_name) }}"
                                    placeholder="Your Last Name..."
                                    autocomplete="family-name"
                                    required
                                >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <input
                                    class="form-control"
                                    name="email"
                                    type="email"
                                    maxlength="100"
                                    value="{{ old('email', $estimate->email) }}"
                                    placeholder="Your Email Address..."
                                    autocomplete="email"
                                    required
                                >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <input
                                    class="form-control"
                                    name="phone"
                                    type="text"
                                    maxlength="20"
                                    value="{{ old('phone', $estimate->phone) }}"
                                    placeholder="Your Mobile Number Including Area Code..."
                                    autocomplete="tel"
                                    required
                                >
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <div class="form-check">
                                    <input type="hidden" name="accepted_terms" value="0">
                                    <input
                                        id="accepted-terms"
                                        class="form-check-input"
                                        type="checkbox"
                                        name="accepted_terms"
                                        value="1"
                                        {{ old('accepted_terms', $estimate->accepted_terms == 1) ? 'checked' : '' }}
                                        required
                                    />
                                    <label id="accepted-terms-label" class="form-check-label" for="accepted-terms">
                                        I confirm that I have read and agree to the
                                        <a href="{{ url(setting('package::estimate.terms_url', '/')) }}" target="_blank">terms and conditions</a>.
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <div class="form-check">
                                    <input type="hidden" name="marketing_emails" value="0">
                                    <input
                                        id="marketing-emails"
                                        class="form-check-input"
                                        type="checkbox"
                                        name="marketing_emails"
                                        {{ old('marketing_emails', $estimate->marketing_emails == 1) ? 'checked' : '' }}
                                        value="1"
                                    />
                                    <label id="marketing-emails-label" class="form-check-label" for="marketing-emails">
                                        I would like to receive tips, advice and news from {{ setting("client::company.name") }}.
                                        I understand I can unsubscribe at any time. We’ll always keep your information
                                        safe and won’t share it with other companies for their marketing purposes.
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>

            <div class="wizard-actions">
                <div class="wizard-next">
                    <button class="form-submit btn btn-block btn-primary" type="submit">
                        Next Step
                    </button>
                </div>
                <div class="wizard-previous">
                    <a href="{{ url('/') }}" class="btn btn-block btn-outline-secondary">
                        Back To Homepage
                    </a>
                </div>
            </div>
        </form>
    @endif
@stop
