@extends('estimate::frontend.layout')

@section('body_class', 'estimate-page')
@section('page_title', 'Step 2 > '.setting('package::estimate.step_2'))
@section('meta_title', 'Step 2 > '.setting('package::estimate.step_2'))
@section('meta_description', 'Step 2 > '.setting('package::estimate.step_2'))

@section('wizard_content')
    <form id="step-2-form" action="{{ route('frontend.estimate.step_2.store') }}" method="POST">
        <div class="validation">
            {{ csrf_field() }}
            @honeypot
            @if(setting()->reCaptchaEnabled())
                {!! RecaptchaV3::field('estimate_step_2') !!}
            @endif
        </div>

        <input id="latitude-input" type="hidden" name="latitude" value="{{ $estimate->latitude }}">
        <input id="longitude-input" type="hidden" name="longitude" value="{{ $estimate->longitude }}">
        <input id="areas-input" type="hidden" name="areas" value="{{ $estimate->areas }}">
        <input id="marker-moved-input" type="hidden" name="marker_moved" value="{{ $estimate->marker_moved ?? 0 }}">
        <input id="total-area-input" type="hidden" name="total_area_m2" value="{{ $estimate->total_area_m2 ?? 0 }}">

        <div class="wizard-content">
            <section>
                <h2>Measure Your Lawn</h2>
                <ol id="map-help" class="pl-3">
                    <li>
                        Drag the <strong class="text-red">'Red Pin'</strong> on the map and place on your property.
                    </li>
                    <li>
                        Next click <strong class="text-green">'Add Area'</strong>
                        and click around the perimeter of the lawn until it shows as
                        <span class="filled-in">completely filled in</span>
                        .
                    </li>
                    <li>
                        If required, you can define multiple lawns, by repeating the above step.
                    </li>
                    <li>
                        You can undo any mistakes, by clicking on <strong class="text-orange">'Delete Last
                            Point'</strong>
                        or <strong class="text-red">'Delete All Points'</strong>.
                    </li>
                    <li>
                        Once you have marked out the required area(s), click <strong class="text-primary">'Get My
                            Quote'</strong>
                        at the bottom to proceed.
                    </li>
                </ol>
            </section>
            <section>
                <div
                    id="map"
                    style="height: 500px;"
                    data-latitude="{{ $estimate->latitude }}"
                    data-longitude="{{ $estimate->longitude }}"
                ></div>
                <div id="map-info">
                    <div class="row">
                        <div id="latitude" class="col-md-3">
                            <div class="label">Latitude</div>
                            <div class="value">{{ $estimate->latitude }}</div>
                        </div>
                        <div id="longitude" class="col-md-3">
                            <div class="label">Longitude</div>
                            <div class="value">{{ $estimate->longitude }}</div>
                        </div>
                        <div id="selected-area" class="col-md-3">
                            <div class="label">Selected Area (m2)</div>
                            <div class="value">{{ $estimate->number_of_m2 ?? 0 }}</div>
                        </div>
                        <div id="total-area" class="col-md-3">
                            <div class="label">Total Area (m2)</div>
                            <div class="value">{{ $estimate->number_of_m2 ?? 0 }}</div>
                        </div>
                    </div>
                </div>
            </section>
        </div>

        <div class="wizard-actions">
            <div class="wizard-next">
                <button
                    id="get-my-quote-btn"
                    class="form-submit btn btn-block btn-primary"
                    type="submit"
                    disabled
                >
                    Get My Quote
                </button>
            </div>
            <div class="wizard-previous">
                <a href="{{ route('frontend.estimate.step_1.show') }}" class="btn btn-block btn-outline-secondary">
                    Previous Step
                </a>
            </div>
        </div>
    </form>
@stop

@section('footer_javascript')
    @parent
    <script src="{{ asset('/js/estimate.js') }}"></script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key={{ setting('system::credentials.google_maps_api_key') }}&callback=initMap&libraries=geometry,drawing&v=weekly"
    ></script>
@endsection
