@extends('estimate::frontend.layout')

@section('body_class', 'estimate-page')
@section('page_title', 'Step 3 > '.setting('package::estimate.step_3'))
@section('meta_title', 'Step 3 > '.setting('package::estimate.step_3'))
@section('meta_description', 'Step 3 > '.setting('package::estimate.step_3'))

@section('wizard_content')
    <div class="wizard-content">

        @include('estimate::frontend.partials.thank_you_text')

        <section class="quote-details">
            <div class="row">
                <div class="col-md-6">
                    <div>
                        <div>
                            <strong>Reference:</strong> {{ config('estimate.number_prefix') }}{{ $estimate->number }}
                        </div>
                        <div>
                            <strong>Location: </strong> {{ $estimate->address }}
                        </div>
                    </div>
                    <div class="measurements mt-4">
                        @if(count($estimate->getAreas()) > 1)
                            <div>
                                <strong>Areas (m2): </strong>
                                <div>
                                    @foreach($estimate->getAreas() as $area)
                                        <div class="ml-3">
                                            <span>{{ $area->label }} - </span>
                                            <span>{{ $area->no_of_m2 ? number_format($area->no_of_m2, 2) : 0 }}</span>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                        <div>
                            <strong>Total Area (m2):</strong>
                            {{ ! empty($estimate->total_area_m2) ? number_format($estimate->total_area_m2, 2) : '0' }}
                        </div>
                    </div>

                    <div class="totals mt-2">
                        <div>
                            <strong>Subtotal:</strong> £{{ ! empty($estimate->subtotal) ? number_format($estimate->subtotal, 2) : '0.00' }}
                        </div>
                        <div>
                            <strong>VAT:</strong> £{{ ! empty($estimate->tax) ? number_format($estimate->tax, 2) : '0.00' }}
                        </div>
                        <div>
                            <strong>Total:</strong> £{{ ! empty($estimate->total) ? number_format($estimate->total, 2) : '0.00' }}
                        </div>
                    </div>

                    <div class="disclaimer mt-2">
                        Price per treatment, of which there are {{ config('estimate.chargeable_treatments_per_year') }} chargeable treatments per year.
                    </div>
                    <div class="mt-4">
                        <strong>Via monthly installments</strong> = £{{ ! empty($estimate->per_month) ? number_format($estimate->per_month, 2) : '0.00' }} per month
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="map">
                        <img class="img-fluid" src="{{ $estimate->getStaticMap() }}" alt="">
                    </div>
                </div>
            </div>
        </section>

        @include('estimate::frontend.partials.footer_text')
    </div>


    <div class="wizard-actions">
        <div class="wizard-next">
            <a
                href="mailto:{{ setting('package::estimate.sales_email') }}?subject=Estimate:KLC-{{ $estimate->number }}"
                class="btn btn-block btn-primary"
                title="Click here to book your first treatment {{ setting('package::estimate.sales_email') }}"
            >
                Book First Treatment Now
            </a>
        </div>
        <div class="wizard-previous">
            <a href="{{ url('/') }}" class="btn btn-block btn-outline-secondary">
                Back To Homepage
            </a>
        </div>
    </div>
@stop
