@extends('framework::mail.layouts.app')

@php
    $cellStyle = 'padding-top: 5px; padding-right: 0; padding-bottom: 5px; padding-left: 0; border:0; vertical-align:top;';
    $labelWidth = '30%';
    $valueWidth = '75%';
@endphp

@section('content')

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <h2 style="margin-top:0; margin-bottom:20px; font-size:24px; line-height:28px; font-weight:bold; letter-spacing:-0.02em;">
            Thank you for considering {{ setting('client::company.name') }}
        </h2>
        <p style="margin-bottom:0">
            Dear {{ $estimate->first_name }},
        </p>
        <p style="margin-bottom:0">
            Thank you for considering us for your lawn care needs. Please find your instant estimate per visit for
            our staple 5-step treatment programme below, with a custom programme to best fit the needs of you and
            your lawn just a conversation away.
        </p>
        <p style="margin-top:1rem;">
            Should you wish to proceed, the next step is for us to arrange one of our senior technicians
            to visit for a complementary lawn assessment to check measurements; provide you with recommendations,
            tailor a programme to your needs, and carry out a first treatment.
        </p>
    @endcomponent

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <table width="100%" cellpadding="0" border="0" cellspacing="0">

            @if(! empty($estimate->number))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Reference</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        {{ config('estimate.number_prefix').$estimate->number }}
                    </td>
                </tr>
            @endif

            @if(! empty($estimate->name))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Name</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        {{ $estimate->name }}
                    </td>
                </tr>
            @endif

            @if(!empty($estimate->email))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Email</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        {{ $estimate->email }}
                    </td>
                </tr>
            @endif

            @if(!empty($estimate->phone))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Phone</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        {{ $estimate->phone }}
                    </td>
                </tr>
            @endif

            @if(!empty($estimate->address))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Location</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        {{ $estimate->address }}
                    </td>
                </tr>
            @endif

        </table>
    @endcomponent

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <table border="0" cellpadding="0" cellspacing="0" role="presentation" style="border-collapse:separate; line-height:100%;">
            <tr>
                <td align="center" bgcolor="#19cca3" role="presentation"
                    style="border:none; border-radius:6px; cursor:auto; padding:11px 20px; background:#19cca3;"
                    valign="middle"
                >
                    <a href="mailto:{{ setting('package::estimate.sales_email') }}?subject=Estimate:{{ config('estimate.number_prefix').$estimate->number }}"
                       style="display:inline-block; background:#19cca3; color:#ffffff; line-height:120%; margin:0; text-decoration:none; text-transform:none;"
                       target="_blank"
                    >
                        Book First Treatment Now
                    </a>
                </td>
            </tr>
        </table>
        <div style="margin-top: 10px;">
            Or call {{ setting('client::company.phone') }} to arrange a booking.
        </div>
    @endcomponent

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <img style="width: 100%;" src="{{ $estimate->getStaticMap() }}" alt="">
    @endcomponent

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <table width="100%" cellpadding="0" border="0" cellspacing="0">

            @if(count($estimate->getAreas()) > 1)
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Areas (m2)</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        @foreach($estimate->getAreas() as $area)
                            <div class="ml-3">
                                <span>{{ $area->label }} - </span>
                                <span>{{ $area->no_of_m2 ? number_format($area->no_of_m2, 2) : 0 }}</span>
                            </div>
                        @endforeach
                    </td>
                </tr>
            @endif

            @if(!empty($estimate->total_area_m2))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Total Area (m2)</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        {{ number_format($estimate->total_area_m2, 2) }}
                    </td>
                </tr>
            @endif

        </table>
    @endcomponent

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <table width="100%" cellpadding="0" border="0" cellspacing="0">

            @if(!empty($estimate->subtotal))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Subtotal</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        £{{ number_format($estimate->subtotal, 2) }}
                    </td>
                </tr>
            @endif

            @if(!empty($estimate->tax))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>VAT</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        £{{ number_format($estimate->tax, 2) }}
                    </td>
                </tr>
            @endif

            @if(!empty($estimate->total))
                <tr>
                    <td width="{{ $labelWidth }}" style="{{ $cellStyle }}">
                        <b>Total</b>
                    </td>
                    <td width="{{ $valueWidth }}" style="{{ $cellStyle }}">
                        £{{ number_format($estimate->total, 2) }}
                    </td>
                </tr>
            @endif
        </table>

        <p style="margin-top: 1rem;">
            Price per treatment, of which there are {{ config('estimate.chargeable_treatments_per_year') }} chargeable treatments per year.
        </p>
        <p style="margin-top: 2rem;">
            <strong>Via monthly installments</strong> = £{{ ! empty($estimate->per_month) ? number_format($estimate->per_month, 2) : '0.00' }} per month
        </p>
    @endcomponent

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <ul style="padding-left:1rem;">
            <li>
                {{ config('estimate.treatments_per_year') }} treatments per year with just
                {{ config('estimate.chargeable_treatments_per_year') }} of those chargeable for <strong>exceptional value</strong>
            </li>
            <li>
                Pet safe treatments that are kind to the soil and the environment
            </li>
            <li>
                <strong>FREE</strong> technician survey and assessment with first treatment (worth £{{ config('estimate.survey_cost') }})
            </li>
            <li>
                <strong>Includes</strong> instant technician report with every treatment
            </li>
            <li>
                <strong>Includes</strong> seasonal customer updates - we build partnerships
            </li>
            <li>
                Unlimited office support - expect excellent customer service
            </li>
            <li>
                <strong>Guaranteed</strong> results within 14 days of your first visit - no risk to you
            </li>
        </ul>
        <p>
            Thanks again for considering us for your lawn care needs. We greatly look forward to speaking with you in
            person in the coming days and making a huge difference to your garden.
        </p>
    @endcomponent
@stop
