Thank you for considering {{ setting('client::company.name') }}

Dear {{ $estimate->first_name }},

Thank you for considering us for your lawn care needs. Please find your instant estimate per visit for
our staple 5-step treatment programme below, with a custom programme to best fit the needs of you and
your lawn just a conversation away.

Should you wish to proceed, the next step is for us to arrange one of our senior technicians
to visit for a complementary lawn assessment to check measurements; provide you with recommendations,
tailor a programme to your needs, and carry out a first treatment.


@if(! empty($estimate->number))
Reference: {{ config('estimate.number_prefix').$estimate->number }}
@endif
@if(! empty($estimate->name))
Name: {{ $estimate->name }}
@endif
@if(! empty($estimate->email))
Email: {{ $estimate->email }}
@endif
@if(! empty($estimate->phone))
Phone: {{ $estimate->phone }}
@endif
@if(! empty($estimate->address))
Location: {{ $estimate->address }}
@endif

Book First Treatment Now by emailing us at {{ setting('package::estimate.sales_email') }}
or call {{ setting('client::company.phone') }} to arrange a booking.

View Map: {{ $estimate->getStaticMap() }}

@if(count($estimate->getAreas()) > 1)
Areas (m2):
@foreach($estimate->getAreas() as $area)
    {{ $area->label }} - {{ $area->no_of_m2 ? number_format($area->no_of_m2, 2) : 0 }}
@endforeach
@endif

@if(! empty($estimate->address))
Total Area (m2): {{ number_format($estimate->total_area_m2, 2) }}
@endif

@if(! empty($estimate->subtotal))
Subtotal: £{{ number_format($estimate->subtotal, 2) }}
@endif
@if(! empty($estimate->tax))
VAT: £{{ number_format($estimate->tax, 2) }}
@endif
@if(! empty($estimate->total))
Total: £{{ number_format($estimate->total, 2) }}
@endif


Price per treatment, of which there are {{ config('estimate.chargeable_treatments_per_year') }} chargeable treatments per year.
Via monthly installments = £{{ ! empty($estimate->per_month) ? number_format($estimate->per_month, 2) : '0.00' }} per month


- {{ config('estimate.treatments_per_year') }} treatments per year with just {{ config('estimate.chargeable_treatments_per_year') }} of those chargeable for exceptional value
- Pet safe treatments that are kind to the soil and the environment
- FREE technician survey and assessment with first treatment (worth £{{ config('estimate.survey_cost') }})
- Includes instant technician report with every treatment
- Includes seasonal customer updates - we build partnerships
- Unlimited office support - expect excellent customer service
- Guaranteed results within 14 days of your first visit - no risk to you

Thanks again for considering us for your lawn care needs. We greatly look forward to speaking with you in
person in the coming days and making a huge difference to your garden.

