<?php

namespace Bongo\Form;

use Bongo\Form\Models\FormItem;
use Bongo\Framework\Providers\AbstractServiceProvider;

use Illuminate\Foundation\AliasLoader;
use ReflectionException;

/**
 * Class FormServiceProvider.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Form
 */
class FormServiceProvider extends AbstractServiceProvider
{
    /**
     * @var string
     */
    protected $module = 'form';

    /**
     * @throws ReflectionException
     */
    public function boot()
    {
        parent::boot();
        AliasLoader::getInstance()->alias('FormItem', FormItem::class);
    }
}
