<?php

namespace Bongo\Form\Http\Controllers\Backend;

use Bongo\Framework\Http\Controllers\AbstractDatatableController;
use Bongo\Form\Models\Form;

use Illuminate\Database\Eloquent\Builder;

/**
 * Class FormDatatableController.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Form\Http\Controllers\Backend
 */
class FormDatatableController extends AbstractDatatableController
{
    /**
     * @var Form
     */
    protected $form;

    /**
     * FormDatatableController constructor.
     *
     * @param Form $form
     */
    public function __construct(Form $form)
    {
        $this->form = $form;
    }

    /**
     * Get base query.
     *
     * @return Builder
     */
    protected function getBaseQuery(): Builder
    {
        return $this->form->newQuery();
    }
}
