<?php

namespace Bongo\Form\Http\Requests;

use Bongo\Form\Models\Form;
use Illuminate\Foundation\Http\FormRequest;

/**
 * Class StoreFormRequest.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Form\Http\Requests
 */
class StoreFormRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(): array
    {
        //$formTable = (new Form())->getTable();

        return [
            'name',
            'success_url',
            'subject',
            'recipients',

            'items.*.label' => 'sometimes|required',
        ];
    }
}
