<?php

namespace Bongo\Form\Mailables;

use Bongo\Form\Models\Form;
use Illuminate\Mail\Mailable;

class AdminFormMailable extends Mailable
{
    protected Form $form;

    protected array $fields;

    protected array $emailFields;

    public function __construct(Form $form, array $fields, array $emailFields)
    {
        $this->form = $form;
        $this->fields = $fields;
        $this->emailFields = $emailFields;
    }

    public function build(): AdminFormMailable
    {
        $mailable = $this;
        $mailable->from(
            config("settings.mail_from_address"),
            config("settings.mail_from_name")
        );
        if (! empty($this->emailFields)) {
            $mailable->replyTo($this->emailFields);
        }
        $mailable->subject('New form submission: '.$this->form->subject);
        $mailable->view('form::mail.admin_response', [
            'form' => $this->form,
            'fields' => $this->fields,
        ]);
        $mailable->text('form::mail.admin_response_plain', [
            'form' => $this->form,
            'fields' => $this->fields,
        ]);

        return $mailable;
    }
}
