<?php

namespace Bongo\Form\Mailables;

use Bongo\Form\Models\Form;
use Illuminate\Contracts\Container\BindingResolutionException;
use Illuminate\Mail\Mailable;

class FormMailable extends Mailable
{
    protected Form $form;

    protected array $fields;

    public function __construct(Form $form, array $fields)
    {
        $this->form = $form;
        $this->fields = $fields;
    }

    public function build(): FormMailable
    {
        return $this
            ->from(
                config("settings.mail_from_address"),
                config("settings.mail_from_name")
            )
            ->replyTo(
                $this->form->getRecipientsAsArray()
            )
            ->subject($this->form->subject)
            ->view('form::mail.response', [
                'form' => $this->form,
                'fields' => $this->fields,
            ])
            ->text('form::mail.response_plain', [
                'form' => $this->form,
                'fields' => $this->fields,
            ]);
    }
}
