<?php

use Bongo\Form\Models\FormItem;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class CreateFormItemsTable.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
class CreateFormItemsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('form_items', function (Blueprint $table) {

            // Primary
            $table->increments('id');
            $table->uuid('uuid')->index();

            // Foreign keys
            $table->unsignedInteger('form_id')->index();

            // Constraints
            $table->foreign('form_id')
                  ->references('id')
                  ->on('forms')
                  ->onUpdate('cascade')
                  ->onDelete('cascade');

            // Fields
            $table->string('label')->nullable();
            $table->string('name')->nullable();
            $table->text('options')->nullable();
            $table->string('class')->nullable();

            $table->enum('required', [
                FormItem::REQUIRED,
                FormItem::NOT_REQUIRED
            ])->default(FormItem::NOT_REQUIRED);

            $table->enum('type', [
                FormItem::CHECKBOX,
                FormItem::DATE,
                FormItem::FILE,
                FormItem::IMAGE,
                FormItem::INPUT,
                FormItem::SELECT,
                FormItem::TEXTAREA
            ])->default(FormItem::INPUT);

            // Audit
            $table->unsignedInteger('sort_order')->nullable()->index();
            $table->unsignedInteger('created_by')->nullable()->index();
            $table->unsignedInteger('updated_by')->nullable()->index();

            // Timestamps
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('form_items');
    }
}
