<?php

use Bongo\Image\Models\Image;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schema;

/**
 * Class AddPlaceholderColumnToFormItemsTable.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
class AddPlaceholderColumnToFormItemsTable extends Migration
{
    /**
     * @return void
     */
    public function up()
    {
        // If the column does not exist then add it
        if (!Schema::hasColumn('form_items', 'placeholder')) {
            Schema::table('form_items', function (Blueprint $table) {

                $table->string('placeholder')
                    ->nullable()
                    ->after('class');
            });
        }
    }

    /**
     * @return void
     */
    public function down()
    {
        Schema::table('form_items', function (Blueprint $table) {
            $table->dropColumn('placeholder');
        });
    }
}
