<?php

use Illuminate\Database\Migrations\Migration;

/**
 * Class AddEmailTypeToFormItemsTable.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
class AddEmailTypeToFormItemsTable extends Migration
{
    /**
     * @return void
     */
    public function up()
    {
        DB::statement("
            ALTER TABLE form_items
            CHANGE COLUMN type
            type ENUM('checkbox','email','date','file','image','input','select','text','textarea')
            DEFAULT 'input'
        ");
    }

    /**
     * @return void
     */
    public function down()
    {
        DB::statement("
            ALTER TABLE form_items
            CHANGE COLUMN type
            type ENUM('checkbox','date','file','image','input','select','text','textarea')
            DEFAULT 'input'
        ");
    }
}
