<?php

use Bongo\Form\Models\FormItem;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class AddDisplayLabelColumnToFormItemsTable.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
class AddDisplayLabelColumnToFormItemsTable extends Migration
{
    /**
     * @return void
     */
    public function up()
    {
        // If the column does not exist then add it
        if (! Schema::hasColumn('form_items', 'display_label')) {
            Schema::table('form_items', function (Blueprint $table) {
                $table->enum('display_label', [
                    FormItem::SHOW_LABEL,
                    FormItem::HIDE_LABEL,
                ])
                    ->default(FormItem::SHOW_LABEL)
                    ->after('label');
            });
        }
    }

    /**
     * @return void
     */
    public function down()
    {
        Schema::table('form_items', function (Blueprint $table) {
            $table->dropColumn('display_label');
        });
    }
}
