<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

/**
 * Class AddWidthColumnToFormItemsTable.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
class AddWidthColumnToFormItemsTable extends Migration
{
    /**
     * @return void
     */
    public function up()
    {
        // If the column does not exist then add it
        if (! Schema::hasColumn('form_items', 'width')) {
            Schema::table('form_items', function (Blueprint $table) {
                $table->string('width')->nullable()->after('class');
            });
        }
    }

    /**
     * @return void
     */
    public function down()
    {
        Schema::table('form_items', function (Blueprint $table) {
            $table->dropColumn('width');
        });
    }
}
