<?php

namespace Bongo\Form\Models;

use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasKey;
use Bongo\Framework\Traits\HasUUID;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * Class Form.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Form\Models
 */
class Form extends AbstractModel
{
    use SoftDeletes;
    use HasKey;
    use HasUUID;

    /**
     * @var array
     */
    protected $fillable = [
        'name',
        'recipients',
        'subject',
        'success_url'
    ];

    /**
     * @return HasMany
     */
    public function items(): HasMany
    {
        return $this->hasMany(FormItem::class, 'form_id')
                    ->orderBy('sort_order', 'ASC');
    }

    /**
     * @return bool
     */
    public function hasItems(): bool
    {
        return !is_null($this->items) && count($this->items);
    }

    /**
     * @return false|string[]
     */
    public function getRecipientsAsArray()
    {
        return explode(',', preg_replace('/\s+/', '', $this->recipients));
    }
}
