<?php

use Illuminate\Support\Facades\Route;

// Backend Routes...
Route::namespace('Bongo\Form\Http\Controllers')
     ->middleware('web')
     ->group(function () {

         Route::namespace('Backend')
              ->middleware(['auth', 'employee'])
              ->prefix(config('settings.backend_prefix'))
              ->as('backend.')
              ->group(function () {

                  // Form
                  Route::as('form.')
                       ->prefix(config('form.prefix'))
                       ->group(function () {

                           Route::get('/')
                                ->name('index')
                                ->uses('FormController@index');

                           Route::get('create')
                                ->name('create')
                                ->uses('FormController@create');

                           Route::post('store')
                                ->name('store')
                                ->uses('FormController@store');

                           Route::get('datatable')
                                ->name('datatable')
                                ->uses('FormDatatableController@index');

                           // Form/{form}/
                           Route::prefix('{form}')
                                ->group(function () {

                                    Route::get('/')
                                         ->name('show')
                                         ->uses('FormController@show');

                                    Route::get('edit')
                                         ->name('edit')
                                         ->uses('FormController@edit');

                                    Route::post('update')
                                         ->name('update')
                                         ->uses('FormController@update');

                                    Route::delete('delete')
                                         ->name('destroy')
                                         ->uses('FormController@destroy');
                                });
                       });
              });
     });
