<?php

use Illuminate\Support\Facades\Route;
use Spatie\Honeypot\ProtectAgainstSpam;

/*
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 */
Route::namespace('Bongo\Form\Http\Controllers')
     ->middleware('web')
     ->group(function () {

         // Frontend Routes...
         Route::namespace('Frontend')
              ->as('frontend.')
              ->group(function () {

                  // Form
                  Route::prefix(config('form.prefix'))
                       ->as('form.')
                       ->group(function () {

                           Route::get('preview/{uuid}')
                                ->name('preview')
                                ->uses('FormController@preview')
                                ->middleware(['auth', 'developer']);

                           Route::post('store')
                                ->name('store')
                                ->uses('FormController@store')
                                ->middleware(ProtectAgainstSpam::class);

                       });
              });
     });
