<?php

namespace Bongo\Form\Traits;

/**
 * Trait HasType.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Form\Traits
 */
trait HasType
{
    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeCheckbox($query)
    {
        return $query->where('type', self::CHECKBOX);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotCheckbox($query)
    {
        return $query->where('type', '!=', self::CHECKBOX);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeFile($query)
    {
        return $query->where('type', self::FILE);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotFile($query)
    {
        return $query->where('type', '!=', self::FILE);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeImage($query)
    {
        return $query->where('type', self::IMAGE);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotImage($query)
    {
        return $query->where('type', '!=', self::IMAGE);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeInput($query)
    {
        return $query->where('type', self::INPUT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotInput($query)
    {
        return $query->where('type', '!=', self::INPUT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeEmail($query)
    {
        return $query->where('type', self::EMAIL);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotEmail($query)
    {
        return $query->where('type', '!=', self::EMAIL);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeSelect($query)
    {
        return $query->where('type', self::SELECT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotSelect($query)
    {
        return $query->where('type', '!=', self::SELECT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeText($query)
    {
        return $query->where('type', self::TEXT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotText($query)
    {
        return $query->where('type', '!=', self::TEXT);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeTextArea($query)
    {
        return $query->where('type', self::TEXTAREA);
    }

    /**
     * @param $query
     *
     * @return mixed
     */
    public function scopeNotTextArea($query)
    {
        return $query->where('type', '!=', self::TEXTAREA);
    }

    /**
     * @return bool
     */
    public function isCheckbox(): bool
    {
        return $this->type === self::CHECKBOX;
    }

    /**
     * @return bool
     */
    public function isFile(): bool
    {
        return $this->type === self::FILE;
    }

    /**
     * @return bool
     */
    public function isImage(): bool
    {
        return $this->type === self::IMAGE;
    }

    /**
     * @return bool
     */
    public function isEmail(): bool
    {
        return $this->type === self::EMAIL;
    }

    /**
     * @return bool
     */
    public function isInput(): bool
    {
        return $this->type === self::INPUT;
    }

    /**
     * @return bool
     */
    public function isSelect(): bool
    {
        return $this->type === self::SELECT;
    }

    /**
     * @return bool
     */
    public function isText(): bool
    {
        return $this->type === self::TEXT;
    }

    /**
     * @return bool
     */
    public function isTextArea(): bool
    {
        return $this->type === self::TEXTAREA;
    }
}
