<section class="md:grid md:grid-cols-2 md:gap-6">
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 lg:grid-cols-2">
                <div class="lg:col-span-1">
                    @input([
                        'label' => 'Form Name',
                        'name' => 'name',
                        'value' => $form->name,
                        'placeholder' => 'Callback Request',
                        'required' => 'true'
                    ])
                </div>
                <div class="lg:col-span-1">
                    @input([
                        'label' => 'Success Url',
                        'name' => 'success_url',
                        'value' => $form->success_url,
                        'placeholder' => '/thank-you',
                        'required' => 'true'
                    ])
                </div>
            </div>
        @endcomponent
    </div>
    <div class="md:col-span-1">
        @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
            <div class="grid grid-cols-1 col-gap-4 row-gap-4 lg:grid-cols-2">
                <div class="lg:col-span-1">
                    @input([
                        'label' => 'Email Subject',
                        'name' => 'subject',
                        'value' => $form->subject,
                        'placeholder' => 'Thank you for your enquiry',
                        'required' => 'true'
                    ])
                </div>
                <div class="lg:col-span-1">
                    @input([
                        'label' => 'Email Recipients',
                        'name' => 'recipients',
                        'value' => $form->recipients,
                        'placeholder' => 'john@test.com, jack@test.com, jill@test.com',
                        'required' => 'true'
                    ])
                </div>
            </div>
        @endcomponent
    </div>
</section>

<section>
    <form-builder :form="{{ json_encode($form) }}"></form-builder>
</section>
