<?php

namespace Bongo\Form\Models;

use Bongo\Framework\Models\AbstractModel;
use Bongo\Framework\Traits\HasKey;
use Bongo\Framework\Traits\HasUUID;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Form extends AbstractModel
{
    use SoftDeletes;
    use HasKey;
    use HasUUID;

    /**
     * @var array
     */
    protected $fillable = [
        'name',
        'recipients',
        'subject',
        'success_url',
    ];

    public function items(): HasMany
    {
        return $this->hasMany(FormItem::class, 'form_id')
            ->orderBy('sort_order', 'ASC');
    }

    public function hasItems(): bool
    {
        return ! is_null($this->items) && count($this->items);
    }

    public function getRecipientsAsArray(): ?array
    {
        return explode(',', preg_replace('/\s+/', '', $this->recipients));
    }
}
