@extends('framework::mail.layouts.app')

@php
    $cellStyle = 'padding-top: 10px; padding-right: 0; padding-bottom: 10px; padding-left: 0; border:0';
@endphp

@section('content')

    @component('framework::mail.layouts.partials.section', ['hasBorder' => true])
        <h1 style="margin-top:0; margin-bottom:20px; font-size:26px; line-height:32px; font-weight:bold; letter-spacing:-0.02em;">
            {{ $form->subject }}
        </h1>
    @endcomponent

    @component('framework::mail.layouts.partials.section')
        <table width="100%" cellpadding="0" border="0" cellspacing="0">
            @foreach($fields as $field)
                <tr>
                    <td width="40%" style="{{ $cellStyle }}">
                        <b>{{ $field['label'] }}</b>
                    </td>
                    <td width="60%" style="{{ $cellStyle }}">
                        @if($field['type'] === FormItem::IMAGE)
                            @foreach($field['value'] as $imageUrl)
                                <a href="{{ asset($imageUrl) }}" title="{{ $imageUrl }}" target="_blank">
                                    <img src="{{ asset($imageUrl) }}" alt="{{ $imageUrl }}" width="250"/>
                                </a>
                                <br/>
                            @endforeach
                        @elseif($field['type'] === FormItem::FILE)
                            @foreach($field['value'] as $imageUrl)
                                <a href="{{ asset($imageUrl) }}" title="{{ $imageUrl }}" target="_blank">
                                    {{ asset($imageUrl) }}
                                </a>
                                <br/>
                            @endforeach
                        @elseif($field['type'] === FormItem::CHECKBOX)
                            {{ $field['value'] == '1' ? 'Yes' : 'No' }}
                        @else
                            {{ $field['value'] }}
                        @endif
                    </td>
                </tr>
            @endforeach
        </table>
    @endcomponent

@stop
