<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPlaceholderColumnToFormItemsTable extends Migration
{
    public function up()
    {
        // If the column does not exist then add it
        if (! Schema::hasColumn('form_items', 'placeholder')) {
            Schema::table('form_items', function (Blueprint $table) {

                $table->string('placeholder')
                    ->nullable()
                    ->after('class');
            });
        }
    }

    public function down()
    {
        Schema::table('form_items', function (Blueprint $table) {
            $table->dropColumn('placeholder');
        });
    }
}
