<?php

use Bongo\Form\Models\FormItem;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddDisplayLabelColumnToFormItemsTable extends Migration
{
    public function up()
    {
        // If the column does not exist then add it
        if (! Schema::hasColumn('form_items', 'display_label')) {
            Schema::table('form_items', function (Blueprint $table) {
                $table->enum('display_label', [
                    FormItem::SHOW_LABEL,
                    FormItem::HIDE_LABEL,
                ])
                    ->default(FormItem::SHOW_LABEL)
                    ->after('label');
            });
        }
    }

    public function down()
    {
        Schema::table('form_items', function (Blueprint $table) {
            $table->dropColumn('display_label');
        });
    }
}
