<?php

use Bongo\Form\Models\FormItem;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFormItemsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('form_items')) {
            Schema::create('form_items', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid('uuid')->index();

                // Foreign keys
                $table->unsignedInteger('form_id')->index();

                // Constraints
                $table->foreign('form_id')
                    ->references('id')
                    ->on('forms')
                    ->onUpdate('cascade')
                    ->onDelete('cascade');

                // Fields
                $table->text('label')->nullable();
                $table->string('name')->nullable();
                $table->text('options')->nullable();
                $table->string('class')->nullable();

                $table->enum('required', [
                    FormItem::REQUIRED,
                    FormItem::NOT_REQUIRED,
                ])->default(FormItem::NOT_REQUIRED);

                $table->enum('type', [
                    FormItem::CHECKBOX,
                    FormItem::DATE,
                    FormItem::FILE,
                    FormItem::IMAGE,
                    FormItem::INPUT,
                    FormItem::SELECT,
                    FormItem::TEXTAREA,
                ])->default(FormItem::INPUT);

                // Audit
                $table->unsignedInteger('sort_order')->nullable()->index();
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();

                // Timestamps
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('form_items');
    }
}
