<?php

use Bongo\Form\Http\Controllers\Backend\FormController;
use Bongo\Form\Http\Controllers\Backend\FormDatatableController;
use Illuminate\Support\Facades\Route;

Route::as('form.')
    ->prefix(config('form.prefix'))
    ->group(function () {

        Route::get('/', [FormController::class, 'index'])
            ->name('index');

        Route::get('create', [FormController::class, 'create'])
            ->name('create');

        Route::post('store', [FormController::class, 'store'])
            ->name('store');

        Route::get('datatable', [FormDatatableController::class, 'index'])
            ->name('datatable');

        // Form/{form}/
        Route::prefix('{form}')
            ->group(function () {

                Route::get('/', [FormController::class, 'show'])
                    ->name('show');

                Route::get('edit', [FormController::class, 'edit'])
                    ->name('edit');

                Route::post('update', [FormController::class, 'update'])
                    ->name('update');

                Route::delete('delete', [FormController::class, 'destroy'])
                    ->name('destroy');
            });
    });
