<?php

use Bongo\Form\Http\Controllers\Frontend\FormController;
use Illuminate\Support\Facades\Route;
use Spatie\Honeypot\ProtectAgainstSpam;

Route::prefix(config('form.prefix'))
    ->as('form.')
    ->group(function () {
        Route::get('preview/{uuid}', [FormController::class, 'preview'])
            ->middleware(['auth', 'developer'])
            ->name('preview');

        Route::post('store', [FormController::class, 'store'])
            ->middleware(ProtectAgainstSpam::class)
            ->name('store');
    });
