<?php

namespace Bongo\Form\Traits;

trait HasType
{
    public function scopeCheckbox($query)
    {
        return $query->where('type', self::CHECKBOX);
    }

    public function scopeNotCheckbox($query)
    {
        return $query->where('type', '!=', self::CHECKBOX);
    }

    public function isCheckbox(): bool
    {
        return $this->type === self::CHECKBOX;
    }

    public function scopeFile($query)
    {
        return $query->where('type', self::FILE);
    }

    public function scopeNotFile($query)
    {
        return $query->where('type', '!=', self::FILE);
    }

    public function isFile(): bool
    {
        return $this->type === self::FILE;
    }

    public function scopeHtml($query)
    {
        return $query->where('type', self::HTML);
    }

    public function scopeNotHtml($query)
    {
        return $query->where('type', '!=', self::HTML);
    }

    public function isHtml(): bool
    {
        return $this->type === self::HTML;
    }

    public function scopeImage($query)
    {
        return $query->where('type', self::IMAGE);
    }

    public function scopeNotImage($query)
    {
        return $query->where('type', '!=', self::IMAGE);
    }

    public function isImage(): bool
    {
        return $this->type === self::IMAGE;
    }

    public function scopeInput($query)
    {
        return $query->where('type', self::INPUT);
    }

    public function scopeNotInput($query)
    {
        return $query->where('type', '!=', self::INPUT);
    }

    public function isInput(): bool
    {
        return $this->type === self::INPUT;
    }

    public function scopeEmail($query)
    {
        return $query->where('type', self::EMAIL);
    }

    public function scopeNotEmail($query)
    {
        return $query->where('type', '!=', self::EMAIL);
    }

    public function isEmail(): bool
    {
        return $this->type === self::EMAIL;
    }

    public function scopeSelect($query)
    {
        return $query->where('type', self::SELECT);
    }

    public function scopeNotSelect($query)
    {
        return $query->where('type', '!=', self::SELECT);
    }

    public function isSelect(): bool
    {
        return $this->type === self::SELECT;
    }

    public function scopeText($query)
    {
        return $query->where('type', self::TEXT);
    }

    public function scopeNotText($query)
    {
        return $query->where('type', '!=', self::TEXT);
    }

    public function isText(): bool
    {
        return $this->type === self::TEXT;
    }

    public function scopeTextArea($query)
    {
        return $query->where('type', self::TEXTAREA);
    }

    public function scopeNotTextArea($query)
    {
        return $query->where('type', '!=', self::TEXTAREA);
    }

    public function isTextArea(): bool
    {
        return $this->type === self::TEXTAREA;
    }
}
