@php
    $reCaptchaEnabled = setting()->reCaptchaEnabled();
    $reCaptchaSiteKey = setting()->getReCaptchaSiteKey();
    $reCaptchaField = uniqid('captcha-response-');
@endphp

<form
    id="{{ $form->uuid }}"
    class="{{ $form->key }}-form has-captcha"
    action="{{ route('frontend.form.store') }}"
    method="POST"
    enctype="multipart/form-data"
    data-recaptcha="{{ $reCaptchaEnabled }}"
    data-recaptcha-key="{{ $reCaptchaSiteKey }}"
    data-recaptcha-field="{{ $reCaptchaField }}"
    data-recaptcha-action="{{ make_key($form->name) }}"
>
    <input class="ref" type="hidden" name="ref" value="{{ $form->uuid }}">

    <div class="validation {{ uniqid('v-') }}" style="display: none;">
        <input class="token" type="hidden" name="_token" value="{{ csrf_token() }}">
        @honeypot
        @if($reCaptchaEnabled)
            <input id="{{ $reCaptchaField }}" type="hidden" name="captcha-response">
        @endif
    </div>

    <div class="row align-items-center">

        @foreach($form->items as $item)
            @if($item->isText())
                @include('form::frontend.partials.text')
            @elseif($item->isHtml())
                @include('form::frontend.partials.html')
            @elseif($item->isTextArea())
                @include('form::frontend.partials.textarea')
            @elseif($item->isCheckbox())
                @include('form::frontend.partials.checkbox')
            @elseif($item->isImage())
                @include('form::frontend.partials.image')
            @elseif($item->isFile())
                @include('form::frontend.partials.file')
            @elseif($item->isSelect())
                @include('form::frontend.partials.select')
            @elseif($item->isEmail())
                @include('form::frontend.partials.email')
            @else
                @include('form::frontend.partials.input')
            @endif
        @endforeach

        <div class="form-group col-12">
            <button
                class="form-submit btn btn-primary font-weight-bold text-uppercase"
                type="submit"
            >
                Submit
            </button>
        </div>
    </div>
</form>

