<div class="form-group col-12 {{ $item->width ?? '' }} {{ $item->class ?? '' }}">
    @if($item->labelIsVisible())
        <label for="{{ $item->name }}-field">
            {{ $item->label }}
        </label>
    @endif
    <select
        id="{{ $item->name }}-field"
        class="form-control {{ isset($errors) && $errors->has($item->name) ? 'is-invalid' : '' }}"
        name="fields[{{$item->name}}]"
        {{ $item->isRequired() ? 'required' : '' }}
    >
        @if($item->hasOptions())
            @foreach($item->getOptionsAsArray() as $option)
                <option value="{{ $option }}"
                    {{ old('fields.'.$item->name) == $option ? 'selected' : '' }}
                >
                    {!! $option !!}
                </option>
            @endforeach
        @endif
    </select>
</div>
