# Changelog

All notable changes to `bongo/form` will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/).

## [Unreleased]

## [3.0.19] - 2026-01-19

### Added
- **AI Context Documentation**: Comprehensive documentation for AI-assisted development
  - `.cursorrules` (370 lines) - Cursor IDE guidance with project structure, patterns, and conventions
  - `CLAUDE.md` (371 lines) - Claude Code quick reference with commands, architecture summary, and key files
  - `ARCHITECTURE.md` (1,057 lines) - Detailed architecture with directory structure, class diagrams, data flows, and extension points
  - `.github/copilot-instructions.md` (436 lines) - GitHub Copilot code templates and patterns
- **Enhanced README.md**: Expanded with comprehensive installation, usage, and integration sections (348 new lines)

### Fixed
- **Form Ref Field**: Added fix for missing form ref field
  - Updated `src/Views/frontend/partials/form.blade.php` to properly include form reference
  - Ensures form submissions are correctly associated with form instances

## [3.0.0] - 2025-11-18

### Major Release - v3.0

This major version represents a complete modernization of the form builder with improved spam protection, validation, and framework integration.

### Changed
- **Custom Captcha Package Integration**: Updated to use new custom captcha package
  - Refactored `FormHandler` to use `Bongo\Captcha\Rules\Captcha` validation rule
  - Updated `src/Views/frontend/partials/form.blade.php` with new captcha implementation
  - Simplified captcha validation logic (11 insertions, 9 deletions)
  - Better integration with framework-level captcha functionality

### Added
- **DT-547**: Google ReCaptcha Score Configuration
  - New `recaptcha.min_score` config option in `src/Config/form.php`
  - Configurable score threshold for reCAPTCHA validation (default: 0.5)
  - Enhanced `FormHandler` to support score-based validation
  - More flexible spam detection based on user interaction scores

### Improved
- **ReCaptcha Functionality Updates**: Modernized reCAPTCHA implementation
  - Updated `FormController` to use new reCAPTCHA methods
  - Added `recaptcha.enabled` config key for package-level control
  - Refactored `FormHandler` validation to use framework helpers
  - Enhanced form template with reCAPTCHA integration (19 insertions, 2 deletions)
  - Consolidated reCAPTCHA logic (51 insertions, 15 deletions)

- **DT-484**: Re-captcha Action
  - Updated form template with proper reCAPTCHA action parameter
  - Improved reCAPTCHA integration for better spam detection

- **Form Name Validation**: Improved form name handling
  - Updated `FormHandler` to remove spaces and hyphens from form name before validating
  - Better compatibility with form naming conventions
  - Prevents validation errors from unconventional form names

### Features
- **DT-435**: Custom Forms HTML Section
  - New `HTML` field type for displaying HTML content in forms
  - Migration `add_html_type_to_form_items_table.php` adds HTML type to enum
  - Updated `FormItem` model with HTML type constant
  - Enhanced `HasType` trait with HTML type checking methods
  - New `src/Views/frontend/partials/html.blade.php` template for rendering HTML fields
  - Updated backend form builder with HTML field support
  - Config option for `allowed_html_tags` to sanitize HTML content
  - `FormController` sanitizes HTML fields on save using `strip_tags()`

- **DT-440**: Form Label Type
  - Enhanced form item labels with better type support
  - Improved label rendering and display options

- **DT-428**: Google ReCaptcha - Env to Settings
  - Moved ReCaptcha configuration from .env to settings
  - Better centralized configuration management
  - Integration with framework settings system

- **DT-417**: Google Re-captcha
  - Implemented Google reCAPTCHA v3 support
  - Added reCAPTCHA to form submissions
  - Score-based spam prevention

### File Uploads
- **DT-179**: Contact Form Images
  - Added image upload support to form builder
  - New `IMAGE` field type with image-specific validation
  - Image upload to temporary storage
  - Auto-purging of old uploaded files

- **DT-179**: Contact Form Version 3
  - Complete overhaul of file upload functionality
  - Enhanced file handling in `FormHandler`
  - Support for both images and documents
  - Configurable allowed file types in config
  - Temporary file storage with auto-cleanup

- **DT-307**: File Upload Types
  - Configurable `allowed_image_types` in config (png, jpg, jpeg, gif)
  - Configurable `allowed_document_types` in config (png, jpg, jpeg, gif, pdf)
  - Better mime type validation
  - Enhanced security for file uploads

### Form Builder Enhancements
- **DT-369**: Form Module - Symbols and Hyphens
  - Improved handling of symbols and hyphens in form names
  - Better field name sanitization
  - Prevents issues with special characters in form submissions

- **DT-369**: Select Option Formatting
  - Removed automatic formatting on select field options
  - Preserves original option values
  - Better control over select field data

- **DT-344**: Form Button Class
  - Added configurable button classes for form styling
  - Better integration with frontend frameworks
  - Customizable submit button appearance

- **DT-243**: Form Labels & Widths
  - Added `display_label` field for custom label display
  - Added `width` field for responsive column layouts
  - Better form layout control
  - Improved mobile responsiveness

- **DT-214**: Form Builder Email Field
  - New dedicated `EMAIL` field type
  - Email validation built-in
  - Automatically used for sending confirmation emails
  - Multiple email recipients supported

- **DT-214**: Form Builder Placeholder
  - Added `placeholder` field to form items
  - Better UX with placeholder text
  - Configurable per field

### Email System
- **DT-294**: Form Emails
  - New `FormMailable` for customer confirmation emails
  - New `AdminFormMailable` for admin notification emails
  - Rich HTML email templates
  - Plain text email alternatives
  - Extends `framework::mail.layouts.app` layout
  - Multiple recipients support via `recipients` field
  - BCC support for admin emails

- **DT-294**: Custom Forms Admin Email
  - Separate admin notification system
  - Configurable admin recipients
  - Form submission data included in email
  - Reply-to set to submitter's email

- **DT-199**: Mail From Name & Address
  - Configurable mail from name and address
  - Uses framework mail settings
  - Consistent email branding

### Database & Migrations
- Migration `add_html_type_to_form_items_table.php` - Adds HTML field type support
- Enhanced install script to check for existing tables before creating
- Better migration handling and rollback support

### Configuration
- **New Config Options**:
  - `prefix` - URL prefix for forms (default: 'forms')
  - `allowed_image_types` - Accepted image mimes
  - `allowed_document_types` - Accepted document mimes
  - `purge_files` - Enable auto-deletion of old files
  - `purge_files_after` - Days before purging (default: 60)
  - `allowed_html_tags` - HTML tags allowed in HTML field type
  - `recaptcha.enabled` - Package-level reCAPTCHA toggle
  - `recaptcha.min_score` - reCAPTCHA score threshold

### Framework Integration
- **Laravel 10 & PHP 8.2 Upgrade**: Complete framework upgrade
  - Updated `composer.json` for Laravel 10 compatibility
  - Updated codebase for PHP 8.2 compatibility
  - Modernized type declarations and nullable types
  - Updated Pint and StyleCI configurations
  - Service provider extends `AbstractServiceProvider`
  - Automatic registration of config, routes, views, migrations, translations

### Statistics
- Complete form builder with 10 field types (INPUT, EMAIL, TEXTAREA, SELECT, CHECKBOX, DATE, FILE, IMAGE, TEXT, HTML)
- Dynamic validation based on field configuration
- File upload with automatic cleanup
- Multi-recipient email notifications
- reCAPTCHA v3 spam protection
- Honeypot middleware protection

## [2.0.15] - 2021-10-28

### Added
- **DT-167**: Form Updates
  - Enhanced form functionality
  - Improved form item handling
  - Better validation and error messages

- **DT-140**: Form Builder
  - Initial form builder implementation
  - CRUD operations for forms and form items
  - Backend admin interface
  - Frontend form rendering
  - Basic field types (INPUT, TEXTAREA, SELECT, CHECKBOX, DATE, FILE)
  - Form submission handling
  - Email notifications

### Initial Release
- Form model with SoftDeletes, HasKey, HasUUID traits
- FormItem model with HasUUID, HasType traits
- FormHandler service for processing submissions
- Backend routes for form management
- Frontend routes for form display and submission
- DataTable integration for form listing
- Events: FormCreated, FormUpdated, FormDeleted
- Mailables for customer and admin notifications
- Honeypot spam protection
- File upload support with temporary storage
- Sort ordering for form items
- Required/optional field configuration
- Custom success URL redirection

---

**Package**: `bongo/form`
**Description**: Add the ability to create custom forms from within the admin.
**Repository**: https://bitbucket.org/designtec/form
**Private Composer Repository**: https://designtecpackages.co.uk
