<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateFormsTable extends Migration
{
    public function up()
    {
        if (! Schema::hasTable('forms')) {
            Schema::create('forms', function (Blueprint $table) {

                // Primary
                $table->increments('id');
                $table->uuid('uuid')->index();

                // Fields
                $table->string('name');
                $table->string('key')->nullable()->index();
                $table->string('success_url')->nullable();

                $table->string('recipients')->nullable();
                $table->string('subject')->nullable();

                // Audit
                $table->unsignedInteger('created_by')->nullable()->index();
                $table->unsignedInteger('updated_by')->nullable()->index();
                $table->unsignedInteger('deleted_by')->nullable()->index();

                // Timestamps
                $table->timestamps();
                $table->softDeletes();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('forms');
    }
}
