<?php

use Illuminate\Database\Migrations\Migration;

class AddHtmlTypeToFormItemsTable extends Migration
{
    public function up(): void
    {
        DB::statement("
            ALTER TABLE `form_items`
            CHANGE COLUMN `type`
            `type` ENUM('checkbox','date','email','file','html','image','input','select','text','textarea')
            DEFAULT 'input'
        ");

        // Change the label field from text to text
        DB::statement("
            ALTER TABLE `form_items`
            MODIFY COLUMN `label` TEXT
            NULL
        ");
    }

    public function down(): void
    {
        DB::statement("
            ALTER TABLE form_items
            CHANGE COLUMN type
            type ENUM('checkbox','date','email','file','image','input','select','text','textarea')
            DEFAULT 'input'
        ");
    }
}
