@extends('framework::backend.layouts.app')

@section('content')

    @component('blade::content_header')
        {{ $form->name }}
        @slot('actions')
            @linkButton(['name' => 'Preview','url' => route('frontend.form.preview', $form->uuid), 'target' => '_blank'])
            @deleteButton(['name' => trans('form::backend.delete'), 'url' => route('backend.form.destroy', $form->id)])
            @backButton(['name' => trans('form::backend.index'), 'url' => route('backend.form.index')])
            @editButton(['name' => trans('form::backend.edit'), 'url' => route('backend.form.edit', $form->id)])
        @endslot
    @endcomponent

    @component('blade::content_body')
        <section class="md:grid md:grid-cols-2 md:gap-6 mb-4">
            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 lg:grid-cols-2">
                        <div class="lg:col-span-1">
                            @static([
                            'name' => 'Form Name',
                            'value' => $form->name
                            ])
                        </div>
                        <div class="lg:col-span-1">
                            @static([
                            'name' => 'Success Url',
                            'value' => $form->success_url
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>

            <div class="md:col-span-1">
                @component('blade::card', ['cardClass' => 'mb-4 md:mb-0'])
                    <div class="grid grid-cols-1 col-gap-4 row-gap-4 lg:grid-cols-2">
                        <div class="lg:col-span-1">
                            @static([
                            'name' => 'Email Subject',
                            'value' => $form->subject
                            ])
                        </div>
                        <div class="lg:col-span-1">
                            @static([
                            'name' => 'Email Recipients',
                            'value' => $form->recipients
                            ])
                        </div>
                    </div>
                @endcomponent
            </div>
        </section>

        <section>
            @if ($form->hasItems())
                @foreach($form->items as $formItem)
                    <div class="mb-2 bg-white overflow-hidden shadow">
                        <div class="px-4 py-3">

                            <div class="flex items-center space-x-2">
                                <div class="flex-grow w-full">
                                    <span class="mr-1 inline-flex items-center px-3 py-0.5 rounded-full text-sm font-medium leading-5 bg-gray-100 text-gray-800">
                                        {{ $formItem->sort_order }}
                                    </span>
                                    @if(! $formItem->isHtml())
                                        <span class="text-sm">
                                            {{ $formItem->label }}
                                        </span>
                                    @endif
                                    @if($formItem->isRequired())
                                        <span class="text-red-500">*</span>
                                    @endif
                                    @if($formItem->hasWidth())
                                        <span class="ml-1 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-orange-100 text-orange-800">
                                            {{ $formItem->width }}
                                        </span>
                                    @endif
                                    @if($formItem->labelIsHidden())
                                        <span class="ml-1 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-yellow-100 text-yellow-800">
                                            no label
                                        </span>
                                    @endif
                                    <span class="ml-1 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium leading-4 bg-indigo-100 text-indigo-800">
                                        {{ $formItem->type }}
                                    </span>
                                </div>
                            </div>

                            @if($formItem->isHtml())
                                <div class="mt-2">
                                    <pre
                                        class="w-full inline-flex text-left items-center bg-gray-800 rounded-lg p-4 pl-6"
                                        style="text-wrap: auto;"
                                    ><code class="max-h-60 overflow-scroll text-sm text-white">{{ $formItem->label }}</code></pre>
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            @else
                @component('blade::card')
                    <div class="message text-center">
                        <div class="message-text font-semibold">
                            No Form Items Found
                        </div>
                    </div>
                @endcomponent
            @endif
        </section>
    @endcomponent
@stop
