<?php

namespace Bongo\Framework\Events;

use Exception;

/**
 * Class AbstractEventHandler.
 *
 * @category  Bespoke_Software
 * @author    Bespoke.ws Ltd <support@bespokeuk.com>
 * @copyright 2015-2020 Bespoke.ws Ltd, All Rights Reserved
 * @license   Proprietary and confidential
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * @link      https://bespokeuk.com
 * @package   Bongo\Framework\Events
 */
class AbstractEventHandler
{
    /**
     * This eloquent model.
     *
     * @var
     */
    protected $model;

    /**
     * Register the listeners for the subscriber.
     *
     * @param $events
     *
     * @throws Exception
     */
    public function subscribe($events)
    {
        if (empty($this->model)) {
            throw new Exception('Please set the model attribute for this event handler');
        }

        $events->listen('eloquent.retrieved: ' . $this->model, get_called_class() . '@onRetrieved');
        $events->listen('eloquent.creating: ' . $this->model, get_called_class() . '@onCreating');
        $events->listen('eloquent.created: ' . $this->model, get_called_class() . '@onCreate');
        $events->listen('eloquent.updating: ' . $this->model, get_called_class() . '@onUpdating');
        $events->listen('eloquent.updated: ' . $this->model, get_called_class() . '@onUpdate');
        $events->listen('eloquent.deleting: ' . $this->model, get_called_class() . '@onDeleting');
        $events->listen('eloquent.deleted: ' . $this->model, get_called_class() . '@onDelete');
        $events->listen('eloquent.saving: ' . $this->model, get_called_class() . '@onSaving');
        $events->listen('eloquent.saved: ' . $this->model, get_called_class() . '@onSave');
    }

    /**
     * Retrieved Function.
     *
     * @param $model
     */
    public function onRetrieved($model)
    {
    }

    /**
     * Creating Function.
     *
     * @param $model
     */
    public function onCreating($model)
    {

    }

    /**
     * Create Function.
     *
     * @param $model
     */
    public function onCreate($model)
    {
    }

    /**
     * Updating Function.
     *
     * @param $model
     */
    public function onUpdating($model)
    {

    }

    /**
     * Update Function.
     *
     * @param $model
     */
    public function onUpdate($model)
    {
    }

    /**
     * Deleting Function.
     *
     * @param $model
     */
    public function onDeleting($model)
    {

    }

    /**
     * Destroy Function.
     *
     * @param $model
     */
    public function onDelete($model)
    {
    }

    /**
     * Saving Function.
     *
     * @param $model
     */
    public function onSaving($model)
    {
    }

    /**
     * Save Function.
     *
     * @param $model
     */
    public function onSave($model)
    {
    }
}
