<?php

namespace Bongo\Framework\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class NoIndex
{
    /**
     * noindex - Do not show this page in search results and do not show a "Cached" link in search results.
     * nofollow - Do not follow the links on this page
     * none - Equivalent to noindex, nofollow
     */
    public function handle(Request $request, Closure $next)
    {
        // Update the headers of the next response
        $response = $next($request);
        $response->headers->set('x-robots-tag', 'none', false);

        return $response;
    }
}
